/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.json;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject$1;
import com.eclipsesource.json.JsonObject$HashIndexTable;
import com.eclipsesource.json.JsonObject$Member;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.JsonWriter;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JsonObject
extends JsonValue
implements Iterable {
    private final List names;
    private final List values;
    private transient JsonObject$HashIndexTable table;

    public JsonObject() {
        this.names = new ArrayList();
        this.values = new ArrayList();
        this.table = new JsonObject$HashIndexTable();
    }

    public JsonObject(JsonObject jsonObject) {
        this(jsonObject, false);
    }

    private JsonObject(JsonObject jsonObject, boolean bl) {
        if (jsonObject == null) {
            throw new NullPointerException("object is null");
        }
        if (bl) {
            this.names = Collections.unmodifiableList(jsonObject.names);
            this.values = Collections.unmodifiableList(jsonObject.values);
        } else {
            this.names = new ArrayList(jsonObject.names);
            this.values = new ArrayList(jsonObject.values);
        }
        this.table = new JsonObject$HashIndexTable();
        this.updateHashIndex();
    }

    @Deprecated
    public static JsonObject readFrom(Reader reader) {
        return JsonValue.readFrom(reader).asObject();
    }

    @Deprecated
    public static JsonObject readFrom(String string) {
        return JsonValue.readFrom(string).asObject();
    }

    public static JsonObject unmodifiableObject(JsonObject jsonObject) {
        return new JsonObject(jsonObject, true);
    }

    public JsonObject add(String string, int n) {
        this.add(string, Json.value(n));
        return this;
    }

    public JsonObject add(String string, long l) {
        this.add(string, Json.value(l));
        return this;
    }

    public JsonObject add(String string, float f) {
        this.add(string, Json.value(f));
        return this;
    }

    public JsonObject add(String string, double d) {
        this.add(string, Json.value(d));
        return this;
    }

    public JsonObject add(String string, boolean bl) {
        this.add(string, Json.value(bl));
        return this;
    }

    public JsonObject add(String string, String string2) {
        this.add(string, Json.value(string2));
        return this;
    }

    public JsonObject add(String string, JsonValue jsonValue) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        this.table.add(string, this.names.size());
        this.names.add(string);
        this.values.add(jsonValue);
        return this;
    }

    public JsonObject set(String string, int n) {
        this.set(string, Json.value(n));
        return this;
    }

    public JsonObject set(String string, long l) {
        this.set(string, Json.value(l));
        return this;
    }

    public JsonObject set(String string, float f) {
        this.set(string, Json.value(f));
        return this;
    }

    public JsonObject set(String string, double d) {
        this.set(string, Json.value(d));
        return this;
    }

    public JsonObject set(String string, boolean bl) {
        this.set(string, Json.value(bl));
        return this;
    }

    public JsonObject set(String string, String string2) {
        this.set(string, Json.value(string2));
        return this;
    }

    public JsonObject set(String string, JsonValue jsonValue) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        int n = this.indexOf(string);
        if (n != -1) {
            this.values.set(n, jsonValue);
        } else {
            this.table.add(string, this.names.size());
            this.names.add(string);
            this.values.add(jsonValue);
        }
        return this;
    }

    public JsonObject remove(String string) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        int n = this.indexOf(string);
        if (n != -1) {
            this.table.remove(n);
            this.names.remove(n);
            this.values.remove(n);
        }
        return this;
    }

    public JsonObject merge(JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException("object is null");
        }
        for (JsonObject$Member jsonObject$Member : jsonObject) {
            this.set(JsonObject$Member.access$000(jsonObject$Member), JsonObject$Member.access$100(jsonObject$Member));
        }
        return this;
    }

    public JsonValue get(String string) {
        if (string == null) {
            throw new NullPointerException("name is null");
        }
        int n = this.indexOf(string);
        return n != -1 ? (JsonValue)this.values.get(n) : null;
    }

    public int getInt(String string, int n) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asInt() : n;
    }

    public long getLong(String string, long l) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asLong() : l;
    }

    public float getFloat(String string, float f) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asFloat() : f;
    }

    public double getDouble(String string, double d) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asDouble() : d;
    }

    public boolean getBoolean(String string, boolean bl) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asBoolean() : bl;
    }

    public String getString(String string, String string2) {
        JsonValue jsonValue = this.get(string);
        return jsonValue != null ? jsonValue.asString() : string2;
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public List names() {
        return Collections.unmodifiableList(this.names);
    }

    public Iterator iterator() {
        Iterator iterator = this.names.iterator();
        Iterator iterator2 = this.values.iterator();
        return new JsonObject$1(this, iterator, iterator2);
    }

    @Override
    void write(JsonWriter jsonWriter) {
        jsonWriter.writeObjectOpen();
        Iterator iterator = this.names.iterator();
        Iterator iterator2 = this.values.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                jsonWriter.writeObjectSeparator();
            }
            jsonWriter.writeMemberName((String)iterator.next());
            jsonWriter.writeMemberSeparator();
            ((JsonValue)iterator2.next()).write(jsonWriter);
            bl = false;
        }
        jsonWriter.writeObjectClose();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JsonObject asObject() {
        return this;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + this.names.hashCode();
        n = 31 * n + this.values.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JsonObject jsonObject = (JsonObject)object;
        return this.names.equals(jsonObject.names) && this.values.equals(jsonObject.values);
    }

    int indexOf(String string) {
        int n = this.table.get(string);
        if (n != -1 && string.equals(this.names.get(n))) {
            return n;
        }
        return this.names.lastIndexOf(string);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.table = new JsonObject$HashIndexTable();
        this.updateHashIndex();
    }

    private void updateHashIndex() {
        int n = this.names.size();
        for (int i = 0; i < n; ++i) {
            this.table.add((String)this.names.get(i), i);
        }
    }
}

