/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.BaseMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTexture$Type;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.net.InetAddress;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import launcher.LOLKekchEbUReK;
import launcher.LOlkekCHebuREk;
import launcher.LoLkekCHebuREk;
import launcher.LolKEKcHEbuREk;
import launcher.lOlKEKchEbUrek;
import launcher.lOlkEKchebureK;
import launcher.lolkeKChebURek;
import launcher.lolkeKcHEBUREK;

public final class YggdrasilMinecraftSessionService
extends BaseMinecraftSessionService {
    public static final JsonParser JSON_PARSER = new JsonParser();
    public static final boolean NO_TEXTURES = Boolean.parseBoolean("launcher.authlib.noTextures");

    public YggdrasilMinecraftSessionService(AuthenticationService authenticationService) {
        super(authenticationService);
        lOlKEKchEbUrek.debug("Patched MinecraftSessionService created");
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile, boolean bl) {
        LolKEKcHEbuREk lolKEKcHEbuREk;
        UUID uUID = gameProfile.getUUID();
        lOlKEKchEbUrek.debug("fillProfileProperties, UUID: %s", uUID);
        if (uUID == null) {
            return gameProfile;
        }
        try {
            lolKEKcHEbuREk = (LolKEKcHEbuREk)new lolkeKcHEBUREK(uUID).request();
        }
        catch (Exception exception) {
            lOlKEKchEbUrek.debug("Couldn't fetch profile properties for '%s': %s", gameProfile, exception);
            return gameProfile;
        }
        if (lolKEKcHEbuREk == null) {
            lOlKEKchEbUrek.debug("Couldn't fetch profile properties for '%s' as the profile does not exist", gameProfile);
            return gameProfile;
        }
        lOlKEKchEbUrek.debug("Successfully fetched profile properties for '%s'", gameProfile);
        YggdrasilMinecraftSessionService.fillTextureProperties(gameProfile, lolKEKcHEbuREk);
        return YggdrasilMinecraftSessionService.toGameProfile(lolKEKcHEbuREk);
    }

    @Override
    public Map getTextures(GameProfile gameProfile, boolean bl) {
        lOlKEKchEbUrek.debug("getTextures, Username: '%s', UUID: '%s'", gameProfile.getName(), gameProfile.getUUID());
        EnumMap<MinecraftProfileTexture$Type, MinecraftProfileTexture> enumMap = new EnumMap<MinecraftProfileTexture$Type, MinecraftProfileTexture>(MinecraftProfileTexture$Type.class);
        if (!NO_TEXTURES) {
            Property property;
            Property property2 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinURL"), null);
            Property property3 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("skinDigest"), null);
            if (property2 != null && property3 != null) {
                enumMap.put(MinecraftProfileTexture$Type.SKIN, new MinecraftProfileTexture(property2.getValue(), property3.getValue()));
            }
            Property property4 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakURL"), null);
            Property property5 = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("cloakDigest"), null);
            if (property4 != null && property5 != null) {
                enumMap.put(MinecraftProfileTexture$Type.CAPE, new MinecraftProfileTexture(property4.getValue(), property5.getValue()));
            }
            if (enumMap.size() != MinecraftProfileTexture.PROFILE_TEXTURE_COUNT && (property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get("textures"), null)) != null) {
                YggdrasilMinecraftSessionService.getTexturesMojang(enumMap, property.getValue(), gameProfile);
            }
        }
        return enumMap;
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String string) {
        LolKEKcHEbuREk lolKEKcHEbuREk;
        String string2 = gameProfile.getName();
        lOlKEKchEbUrek.debug("checkServer, Username: '%s', Server ID: %s", string2, string);
        try {
            lolKEKcHEbuREk = (LolKEKcHEbuREk)new LOLKekchEbUReK(string2, string).request();
        }
        catch (Exception exception) {
            lOlKEKchEbUrek.error(exception);
            throw new AuthenticationUnavailableException(exception);
        }
        return lolKEKcHEbuREk == null ? null : YggdrasilMinecraftSessionService.toGameProfile(lolKEKcHEbuREk);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String string, InetAddress inetAddress) {
        return this.hasJoinedServer(gameProfile, string);
    }

    @Override
    public void joinServer(GameProfile gameProfile, String string, String string2) {
        boolean bl;
        if (!lOlkEKchebureK.isLaunched()) {
            throw new AuthenticationException("Bad Login (Cheater)");
        }
        String string3 = gameProfile.getName();
        lOlKEKchEbUrek.debug("joinServer, Username: '%s', Access token: %s, Server ID: %s", string3, string, string2);
        try {
            bl = (Boolean)new LoLkekCHebuREk(string3, string, string2).request();
        }
        catch (Exception exception) {
            throw new AuthenticationUnavailableException(exception);
        }
        if (!bl) {
            throw new AuthenticationException("Bad Login (Clientside)");
        }
    }

    public static void fillTextureProperties(GameProfile gameProfile, LolKEKcHEbuREk lolKEKcHEbuREk) {
        lOlKEKchEbUrek.debug("fillTextureProperties, Username: '%s'", gameProfile.getName());
        if (NO_TEXTURES) {
            return;
        }
        PropertyMap propertyMap = gameProfile.getProperties();
        if (lolKEKcHEbuREk.skin != null) {
            propertyMap.put("skinURL", new Property("skinURL", lolKEKcHEbuREk.skin.url, ""));
            propertyMap.put("skinDigest", new Property("skinDigest", lolkeKChebURek.toHex(lolKEKcHEbuREk.skin.digest), ""));
            lOlKEKchEbUrek.debug("fillTextureProperties, Has skin texture for username '%s'", gameProfile.getName());
        }
        if (lolKEKcHEbuREk.cloak != null) {
            propertyMap.put("cloakURL", new Property("cloakURL", lolKEKcHEbuREk.cloak.url, ""));
            propertyMap.put("cloakDigest", new Property("cloakDigest", lolkeKChebURek.toHex(lolKEKcHEbuREk.cloak.digest), ""));
            lOlKEKchEbUrek.debug("fillTextureProperties, Has cloak texture for username '%s'", gameProfile.getName());
        }
    }

    public static GameProfile toGameProfile(LolKEKcHEbuREk lolKEKcHEbuREk) {
        GameProfile gameProfile = new GameProfile(lolKEKcHEbuREk.uuid, lolKEKcHEbuREk.username);
        YggdrasilMinecraftSessionService.fillTextureProperties(gameProfile, lolKEKcHEbuREk);
        return gameProfile;
    }

    private static void getTexturesMojang(Map map, String string, GameProfile gameProfile) {
        JsonObject jsonObject;
        Object object;
        try {
            object = Base64.getDecoder().decode(string);
            jsonObject = JSON_PARSER.parse(new String((byte[])object, LOlkekCHebuREk.UNICODE_CHARSET)).getAsJsonObject().getAsJsonObject("textures");
        }
        catch (Exception exception) {
            lOlKEKchEbUrek.error("Could not decode textures payload, Username: '%s', UUID: '%s'", gameProfile.getName(), gameProfile.getUUID());
            return;
        }
        object = MinecraftProfileTexture.PROFILE_TEXTURE_TYPES.iterator();
        while (object.hasNext()) {
            JsonElement jsonElement;
            JsonElement jsonElement2;
            MinecraftProfileTexture$Type minecraftProfileTexture$Type = (MinecraftProfileTexture$Type)((Object)object.next());
            if (map.containsKey((Object)minecraftProfileTexture$Type) || (jsonElement2 = jsonObject.get(minecraftProfileTexture$Type.name())) == null || !jsonElement2.isJsonObject() || !(jsonElement = jsonElement2.getAsJsonObject().get("url")).isJsonPrimitive()) continue;
            map.put(minecraftProfileTexture$Type, new MinecraftProfileTexture(jsonElement.getAsString()));
        }
    }
}

